<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */
 
  /*********** installation ****************

  1. upload sitemap.php into indexu folder
  2. upload sitemap1.xml.gz until sitemap7.xml.gz
     and sitemap_index.xml.gz, then chmod 777
  3. set daily cron job for sitemap.php
     0 0 * * * GET http://www.mydomain.com/sitemap.php > /dev/null

  ******************************************/

  function SitemapHeader() {
    return
      "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".
      "<urlset xmlns=\"http://www.google.com/schemas/sitemap/0.84\">\n";
  }

  function SitemapFooter() {
    return "</urlset>";
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  /*********** setting ****************/

  $index_changefreq    = "daily";
  $index_priority      = "1.0";

  $category_changefreq = "weekly";
  $category_priority   = "0.6";

  $detail_changefreq   = "weekly";
  $detail_priority     = "0.5";

  $number_of_sitemap_files = 6; // one for index+category page
                                // six for detail pages, max=50,000x6 detail pages
                                // make sure to upload more sitemap8.xml.gz if necassary

  /*********** generator **************/

  // generate sitemap1.xml.gz (index page + category pages)

  // index.php

  $last_mod = date("Y-m-d");

  $content =
    "<url>\n".
    "  <loc>$site_url</loc>\n".
    "  <lastmod>$last_mod</lastmod>\n".
    "  <changefreq>$index_changefreq</changefreq>\n".
    "  <priority>$index_priority</priority>\n".
    "</url>\n";
    
  // browse.php

  $query = "select a.category_id, a.name, b.path
            from idx_category a
                 left join idx_category_path b on (a.category_id = b.category_id)
            where visible = 1";
  $categories = $dbConn->FetchArray($query);

  foreach($categories as $k => $v) {
    $cat_id   = $v['category_id'];
    $cat_name = $v['name'];
    $cat_path = $v['path'];

    if (GetModRewriteStatus()=='1') {
      $cat_name2 = SEOReplace($cat_name);
      $mod_rewrite_pattern = GetModRewritePatternCategory();
      $mod_rewrite_pattern = str_replace('{$cat_name}',$cat_name2,$mod_rewrite_pattern);
      $mod_rewrite_pattern = str_replace('{$cat_id}',$cat_id,$mod_rewrite_pattern);
      $mod_rewrite_pattern = str_replace('{$page}','1',$mod_rewrite_pattern);
      if (strpos($mod_rewrite_pattern, '{$cat_path}') !== FALSE) {
        $mod_rewrite_pattern = substr($mod_rewrite_pattern, 0, strrpos($mod_rewrite_pattern, '/') + 1);
        $cat_path2 = SEOReplace(str_replace($category_separator, 'indexuslash', $cat_path));
        $cat_path2 = str_replace('indexuslash', '/', $cat_path2);
        $mod_rewrite_pattern = str_replace('{$cat_path}',$cat_path2,$mod_rewrite_pattern);
        $mod_rewrite_pattern = str_replace('//', '/', $mod_rewrite_pattern);
      }
      $cat_url   = $mod_rewrite_pattern;
    }
    else {
      $cat_url   = strtolower("browse.php?cat=$cat_id");
    }
    
    $content .=
      "<url>\n".
      "  <loc>$site_url/$cat_url</loc>\n".
      "  <changefreq>$category_changefreq</changefreq>\n".
      "  <priority>$category_priority</priority>\n".
      "</url>\n";
  }
  
  // write gz file

  $zp = gzopen("sitemap1.xml.gz", "w9");
  gzwrite($zp, SitemapHeader().$content.SitemapFooter());
  gzclose($zp);
  
  unset($content);


  // generate sitemap2.xml.gz to sitemap7.xml.gz (detail pages)

  // get total detail pages

  $query  = "select count(link_id) as c from idx_link where suspended=0";
  $result = $dbConn->Execute($query);
  $total  = $result->Fields("c");
  
  $total_each_loop = $total / $number_of_sitemap_files;
  
  $i=0;
  while($i<$number_of_sitemap_files) {
    $limit1 = $i * $total_each_loop;
    $limit2 = ($i+1) * $total_each_loop;
    $query  = "select link_id, title, date, last_updated from idx_link where suspended=0 limit $limit1,$limit2";
    $links = $dbConn->FetchArray($query);

    foreach($links as $k => $v) {
      $link_id      = $v['link_id'];
      $title        = $v['title'];
      $date         = $v['date'];
      $last_updated = $v['last_updated'];

      $title_mod = strtolower($title);
      $title_mod = SEOReplace($title_mod);

      if (GetModRewriteStatus()=='1') {
        $mod_rewrite_pattern = GetModRewritePatternDetail();
        $mod_rewrite_pattern = str_replace('{$link_title}',$title_mod,$mod_rewrite_pattern);
        $mod_rewrite_pattern = str_replace('{$link_id}',$link_id,$mod_rewrite_pattern);
        $detail_page_url     = $mod_rewrite_pattern;
      }
      else {
        $detail_page_url     = "detail.php?linkid=$link_id";
      }

      if (!empty($last_update)) {
        $last_mod = date("Y-m-d",strtotime($last_update));
      }
      else {
        $last_mod = date("Y-m-d",strtotime($date));
      }

      $content .=
        "<url>\n".
        "  <loc>$site_url/$detail_page_url</loc>\n".
        "  <lastmod>$last_mod</lastmod>\n".
        "  <changefreq>$detail_changefreq</changefreq>\n".
        "  <priority>$detail_priority</priority>\n".
        "</url>\n";
    }

    // write gz file

    $c = $i+2;
    $filename = "sitemap{$c}.xml.gz";
    $zp = gzopen($filename, "w9");
    gzwrite($zp, utf8_encode(SitemapHeader().$content.SitemapFooter()));
    gzclose($zp);

    unset($content);

    $i++;
  }
  

  // generate sitemap index

  $i=0;
  while($i<=$number_of_sitemap_files) {
    $c = $i+1;
    $filename = "sitemap{$c}.xml.gz";
    $date     = date("Y-m-d");

    $sitemap_files .=
      "<sitemap>\n".
      "  <loc>$site_url/$filename</loc>\n".
      "  <lastmod>$date</lastmod>\n".
      "</sitemap>\n";
    $i++;
  }
  


  $content =
    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".
    "<sitemapindex xmlns=\"http://www.google.com/schemas/sitemap/0.84\">\n".
    $sitemap_files.
    "</sitemapindex>\n";

  // write gz file

  $zp = gzopen("sitemap_index.xml.gz", "w9");
  gzwrite($zp, utf8_encode($content));
  gzclose($zp);

  print "Sitemap has been generated!";

  RunPostFilter(__FILE__);

?>